﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Reflection
{
	public static class ReflectionProgram
	{
		private const int ITERATIONS = 1000000;

		public static void Main(string[] args)
		{
			while (true)
			{
				var instance = new MyClass();
				var sw = new Stopwatch();

				// standardní nastavení
				sw.Restart();
				for (int i = 0; i < ITERATIONS; i++)
				{
					instance.MyProperty = i;
				}
				sw.Stop();
				Console.WriteLine($"Static-typing:           {sw.ElapsedTicks, 10:n0} CPU ticks");

				// reflection s cacheovaným PropertyInfo
				sw.Restart();
				var propInfo = typeof(MyClass).GetProperty("MyProperty");
				for (int i = 0; i < ITERATIONS; i++)
				{
					propInfo.SetValue(instance, i, null);
				}
				sw.Stop();
				Console.WriteLine($"Cacheované PropertyInfo: {sw.ElapsedTicks, 10:n0} CPU ticks");

				// reflection
				sw.Restart();
				for (int i = 0; i < ITERATIONS; i++)
				{
					propInfo = typeof(MyClass).GetProperty("MyProperty");
					propInfo.SetValue(instance, i, null);
				}
				sw.Stop();
				Console.WriteLine($"Vždy nové GetProperty:   {sw.ElapsedTicks, 10:n0} CPU ticks");

				// dynamic
				sw.Restart();
				dynamic dyn = instance;
				for (int i = 0; i < ITERATIONS; i++)
				{
					dyn.MyProperty = i;
				}
				sw.Stop();
				Console.WriteLine($"Dynamic:                 {sw.ElapsedTicks, 10:n0} CPU ticks");

				Console.WriteLine();
				Thread.Sleep(5000);
			}
		}

		public class MyClass
		{
			public int MyProperty { get; set; }
		}
	}
}
